function AISMN_AnalyzeThreat::OnEnter(%this,%obj)
{
   //Get the threat. If it does not exist, then we'll send the message.
   %threat = GetStimulus(%obj);
   if(0 == %threat)
   {
      SetStateVariable(%obj,0,1.0); //No threat exists
      return;
   }
   
   //Get the number of buildings within sight
   %building = GetTeamBuildingWithinSight(%obj);
   if(0 == %building)
   {
      SetStateVariable(%obj,0,2.0); //No buildings exist
      return;
   }
   
   //Set a path to the building
   SetPathToSpot( %obj, GetBuildingDoorX(%building),GetBuildingDoorX(%building) );
   GetThisObject(%obj).playThread( 0, "run");
   
   return;
}

function AISMN_AnalyzeThreat::OnExit(%this,%obj)
{
   GetThisObject(%obj).playThread( 0, "root");
   return;
}

//EXIT 0: NO THREAT EXISTS.
//EXIT 1: NO BUILDINGS WITHIN SIGHT.
//EXIT 2: ARRIVED AT BUILDING
function AISMN_AnalyzeThreat::Update(%this,%obj)
{
   //Get the state variable, if it has changed.
   %result = GetStateVariable(%obj,0);
   
   //If there's no threat...
   if(%result == 1.0)
   {
      ReturnValue(%obj,0);
      return;
   }
   //If there are no buildings to hide in
   else if(%result == 2.0)
   {
      ReturnValue(%obj,1);
      return;
   }
   
   //If we arrived at a destination, return success.
   if(!IsFollowingPath(%obj))
   {
      ReturnValue(%obj,2);
      return;
   }
   ReturnValue(%obj,-1);
   return;
}